/* Copyright (c) 2022-2023 VMware, Inc. All rights reserved. */
package com.vmware.automatic.plugin.registration.services;

import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.security.SecureRandom;

@PrepareForTest(SSLContext.class)
public class SslTrustStrategyTest extends PowerMockTestCase {

   private SslTrustStrategy trustManager;
   private SSLContext sslContextMock;
   private SSLSessionContext sslSessionContextMock;
   private SSLSocketFactory sslSocketFactoryMock;

   @BeforeMethod
   public void init() {
      trustManager = new SslTrustStrategy();
      sslContextMock = PowerMockito.mock(SSLContext.class);
      sslSessionContextMock = PowerMockito.mock(SSLSessionContext.class);
      sslSocketFactoryMock = PowerMockito.mock(SSLSocketFactory.class);
   }

   @Test
   public void trustAll() throws Exception {
      // Set mock expectations
      PowerMockito.mockStatic(SSLContext.class);
      Mockito.when(SSLContext.getInstance("SSL")).thenReturn(sslContextMock);
      Mockito.when(sslContextMock.getServerSessionContext()).thenReturn(sslSessionContextMock);
      Mockito.when(sslContextMock.getSocketFactory()).thenReturn(sslSocketFactoryMock);
      Mockito.doNothing().when(sslSessionContextMock).setSessionTimeout(Mockito.isA(Integer.class));

      trustManager.init(true, "vc-server-thumbprint");

      // Verify method invocations
      PowerMockito
            .verifyStatic(SSLContext.class, VerificationModeFactory.times(1));
      SSLContext.getInstance("SSL");
      Mockito.verify(sslContextMock, Mockito.times(1))
            .getServerSessionContext();
      Mockito.verify(sslSessionContextMock, Mockito.times(1))
            .setSessionTimeout(0);
      Mockito.verify(sslContextMock, Mockito.times(1))
            .init(Mockito.isNull(KeyManager[].class),
                  Mockito.any(TrustManager[].class),
                  Mockito.isNull(SecureRandom.class));
   }

}
